/*
 * Decompiled with CFR 0.152.
 */
package emulator.shell.GUI.symbols;

import emulator.assembler.SymbolTable;
import emulator.assembler.SymbolTableEntry;
import emulator.assembler.SymbolTableSource;
import emulator.shell.DebugShell;
import emulator.shell.GUI.debugger.CodePanel;
import emulator.shell.GUI.symbols.SymbolTableVM;
import emulator.shell.GUI.symbols.SymbolTableView;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;

public class SymbolTablePresenter {
    private SymbolTableView view;
    private String appName;
    private CodePanel codePanel;

    public SymbolTablePresenter(String appName, CodePanel codePanel) {
        this.appName = appName;
        this.codePanel = codePanel;
    }

    public void toggleView() {
        if (this.view == null) {
            this.view = new SymbolTableView(this.appName, this);
            this.view.initView(this.createViewModel());
            this.view.restorePosition();
            this.view.setVisible(true);
        } else {
            this.view.toFront();
        }
    }

    private SymbolTableVM createViewModel() {
        SymbolTableVM viewModel = new SymbolTableVM();
        SymbolTable symbolTable = this.codePanel.getSymbolTable();
        for (SymbolTableEntry entry : symbolTable.getSymbols()) {
            viewModel.addSymbol(entry);
        }
        return viewModel;
    }

    public void showCode(int address) {
        if (this.codePanel != null) {
            this.codePanel.showCode(address, true);
        }
    }

    public void onCloseView() {
        this.view = null;
    }

    public void closeView() {
        if (this.view != null) {
            this.view.setVisible(false);
            this.view = null;
        }
    }

    public void loadSymbols(String symbolFileName) {
        this.codePanel.loadSymbols(symbolFileName);
        this.view.updateViewModel(this.createViewModel());
    }

    public void saveSymbols(String fileName, Collection<SymbolTableSource> selectedSources) {
        block12: {
            FileOutputStream file = null;
            try {
                try {
                    file = new FileOutputStream(fileName);
                    this.codePanel.getSymbolTable().save(file, selectedSources);
                }
                catch (IOException e) {
                    DebugShell.getInstance().getErr().println("File write failed for \"" + fileName + "\" (symbols): " + e.getMessage());
                    if (file == null) break block12;
                    try {
                        file.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public void deleteSymbols(Collection<SymbolTableSource> selectedSources) {
        this.codePanel.getSymbolTable().delete(selectedSources);
        this.view.updateViewModel(this.createViewModel());
    }
}

